/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.MorphologyDialog;

import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import net.nooj4nlp.controller.MorphologyDialog.AnimationTask;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.Regexp;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.main.Launcher;

public class ButtonListener
implements ActionListener {
    private JList listLanguage;
    private JComboBox comboWordRoot;
    private JComboBox comboCommandSuffix;
    private JComboBox comboLemma;
    private JComboBox comboExpression;
    private JComboBox comboLookup;
    private JRadioButton rdbtnWordCommand;
    private JRadioButton rdbtnLemmaExpression;
    private JRadioButton rdbtnLookup;
    private DefaultListModel resultModel;
    private JPanel pnlResult;
    private String word;
    private String command;
    private int icommand;
    private Regexp exp;

    public ButtonListener(JList listLanguage, JComboBox comboWordRoot, JComboBox comboCommandSuffix, JComboBox comboLemma, JComboBox comboExpression, JComboBox comboLookup, JRadioButton rdbtnWordCommand, JRadioButton rdbtnLemmaExpression, JRadioButton rdbtnLookup, DefaultListModel resultModel, JPanel pnlResult) {
        this.listLanguage = listLanguage;
        this.comboWordRoot = comboWordRoot;
        this.comboCommandSuffix = comboCommandSuffix;
        this.comboLemma = comboLemma;
        this.comboExpression = comboExpression;
        this.comboLookup = comboLookup;
        this.rdbtnWordCommand = rdbtnWordCommand;
        this.rdbtnLemmaExpression = rdbtnLemmaExpression;
        this.rdbtnLookup = rdbtnLookup;
        this.resultModel = resultModel;
        this.pnlResult = pnlResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent arg0) {
        block24: {
            int index;
            Language lan;
            block23: {
                int index2;
                this.resultModel.removeAllElements();
                lan = new Language((String)this.listLanguage.getSelectedValue());
                if (this.rdbtnWordCommand.isSelected()) {
                    int index3;
                    if (this.comboWordRoot.getSelectedItem() == null || ((String)this.comboWordRoot.getSelectedItem()).equals("")) {
                        JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please type in a word form", "NooJ", 1);
                        return;
                    }
                    this.word = (String)this.comboWordRoot.getSelectedItem();
                    if (this.word.charAt(0) == '[' && (index3 = this.word.indexOf("] ")) != -1) {
                        this.word = this.word.substring(index3 + 2);
                    }
                    if (this.comboCommandSuffix.getSelectedItem() == null || ((String)this.comboCommandSuffix.getSelectedItem()).equals("")) {
                        JOptionPane.showMessageDialog(null, "Please type in a command", "NooJ", 1);
                        return;
                    }
                    this.command = (String)this.comboCommandSuffix.getSelectedItem();
                    if (this.command.charAt(0) == '[' && (index3 = this.command.indexOf("] ")) != -1) {
                        this.command = this.command.substring(index3 + 2);
                    }
                    this.icommand = 0;
                    try {
                        CursorChangeEffect.setCustomCursor(3);
                        this.resultModel.addElement(this.word + "\u2502 " + this.command);
                        Timer timer = new Timer();
                        AnimationTask task = new AnimationTask(this.resultModel, this.word, this.command, this.icommand, lan, timer);
                        timer.scheduleAtFixedRate((TimerTask)task, 1000L, 1000L);
                    }
                    finally {
                        CursorChangeEffect.setCustomCursor(0);
                    }
                }
                if (!this.rdbtnLemmaExpression.isSelected()) break block23;
                if (this.comboLemma.getSelectedItem() == null || ((String)this.comboLemma.getSelectedItem()).equals("")) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please type in a lemma", "NooJ", 1);
                    return;
                }
                this.word = (String)this.comboLemma.getSelectedItem();
                if (this.word.charAt(0) == '[' && (index2 = this.word.indexOf("] ")) != -1) {
                    this.word = this.word.substring(index2 + 2);
                }
                if (this.comboExpression.getSelectedItem() == null || ((String)this.comboExpression.getSelectedItem()).equals("")) {
                    JOptionPane.showMessageDialog(null, "Please type in a command", "NooJ", 1);
                    return;
                }
                this.command = (String)this.comboExpression.getSelectedItem();
                if (this.command.charAt(0) == '[' && (index2 = this.command.indexOf("] ")) != -1) {
                    this.command = this.command.substring(index2 + 2);
                }
                this.exp = new Regexp(this.command);
                String[] forms = null;
                String[] outputs = null;
                RefObject<Object> formsRef = new RefObject<Object>(forms);
                RefObject<Object> outputsRef = new RefObject<Object>(outputs);
                this.exp.Grm.inflect(lan, this.word, formsRef, outputsRef, null);
                forms = (String[])formsRef.argvalue;
                outputs = (String[])outputsRef.argvalue;
                if (forms == null) {
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot inflect lemma \"" + this.word + "\"", "NooJ", 1);
                    return;
                }
                this.pnlResult.setBorder(new TitledBorder(null, "Lemma '" + this.word + "' has " + forms.length + " forms:", 4, 2, null, null));
                for (int i = 0; i < forms.length; ++i) {
                    this.resultModel.addElement(outputs[i] + " => " + forms[i]);
                }
                break block24;
            }
            if (!this.rdbtnLookup.isSelected()) break block24;
            if (this.comboLookup.getSelectedItem() == null || ((String)this.comboLookup.getSelectedItem()).equals("")) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Please type in a word", "NooJ", 1);
                return;
            }
            this.word = (String)this.comboLookup.getSelectedItem();
            if (this.word.charAt(0) == '[' && (index = this.word.indexOf("] ")) != -1) {
                this.word = this.word.substring(index + 2);
            }
            RefObject<Language> lanRef = new RefObject<Language>(lan);
            Engine engine = new Engine(lanRef, Paths.applicationDir, Paths.docDir, Paths.projectDir, Launcher.projectMode, Launcher.preferences, Launcher.backgroundWorking, Launcher.backgroundWorker);
            lan = (Language)lanRef.argvalue;
            String errorMessage = "";
            RefObject<String> errmessageRef = new RefObject<String>(errorMessage);
            try {
                if (!engine.loadResources(Launcher.preferences.ldic.get(lan.isoName), null, true, errmessageRef)) {
                    errorMessage = (String)errmessageRef.argvalue;
                    JOptionPane.showMessageDialog(Launcher.getDesktopPane(), errorMessage, "NooJ: cannot load linguistic resources", 0);
                    return;
                }
            }
            catch (HeadlessException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "No input devices found!", 0);
                return;
            }
            catch (ClassNotFoundException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
                return;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
                return;
            }
            ArrayList<String> sols = engine.lookup(-1, (String)this.comboLookup.getSelectedItem(), false, null, -1, null);
            if (sols == null || sols.size() == 0) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot find any lexical entry for word " + (String)this.comboLookup.getSelectedItem(), "NooJ", 0);
                return;
            }
            this.resultModel.removeAllElements();
            ArrayList<String> res = engine.inflectSolutions(sols);
            for (int i = 0; i < res.size(); i += 2) {
                this.resultModel.addElement(res.get(i + 1) + " => " + res.get(i));
            }
        }
    }
}

